PROC TABULATE DATA=ghpb18  MISSING NOSEPS;  
 
CLASS BIZCODE INS3 ent3 filingsize / PRELOADFMT;
TITLE 'Table A10. Distribution of Group Health Plans';
title2 'by type of insurance, type of plan, and industry, 2018';
title3 'All Plans';
VAR DUP_WGT;
TABLE   ALL='Total'*SUM=' '*DUP_WGT=' '*f=comma9. bizcode=' '*SUM=' '*DUP_WGT=' '*F=COMMA9.,
		(ALL='All Plans' INS3=' ')*(ALL='Total' ent3=' ')/MISSTEXT='-' box='Industry';
RUN;

PROC TABULATE DATA=ghpb18  MISSING NOSEPS;                                                                                                                                                      
WHERE FILINGSIZE='1';
CLASS BIZCODE INS3 ent3 filingsize / PRELOADFMT;
TITLE 'Table A10. Distribution of Group Health Plans';
title2 'by type of insurance, type of plan, and industry, 2018';
title3 'Plans with 100 or More Participants and Trusts';
VAR DUP_WGT;
TABLE   ALL='Total'*SUM=' '*DUP_WGT=' '*f=comma9. bizcode=' '*SUM=' '*DUP_WGT=' '*F=COMMA9.,
		(ALL='All Plans' INS3=' ')*(ALL='Total' ent3=' ')/MISSTEXT='-' box='Industry';
RUN;

PROC TABULATE DATA=ghpb18  MISSING NOSEPS;                                                                                                                                                      
WHERE FILINGSIZE='2';
CLASS BIZCODE INS3 ent3 filingsize / PRELOADFMT;
TITLE 'Table A10. Distribution of Group Health Plans';
title2 'by type of insurance, type of plan, and industry, 2018';
title3 'Plans with 100 or More Participants and No Trusts';
VAR DUP_WGT;
TABLE   ALL='Total'*SUM=' '*DUP_WGT=' '*f=comma9. bizcode=' '*SUM=' '*DUP_WGT=' '*F=COMMA9.,
		(ALL='All Plans' INS3=' ')*(ALL='Total' ent3=' ')/MISSTEXT='-' box='Industry';
RUN;

PROC TABULATE DATA=ghpb18  MISSING NOSEPS;                                                                                                                                                      
WHERE FILINGSIZE='3';
CLASS BIZCODE INS3 ent3 filingsize / PRELOADFMT;
TITLE 'Table A10. Distribution of Group Health Plans';
title2 'by type of insurance, type of plan, and industry, 2018';
title3 'Plans with Fewer Than 100 Participants and Trusts';
VAR DUP_WGT;
TABLE   ALL='Total'*SUM=' '*DUP_WGT=' '*f=comma9. bizcode=' '*SUM=' '*DUP_WGT=' '*F=COMMA9.,
		(ALL='All Plans' INS3=' ')*(ALL='Total' ent3=' ')/MISSTEXT='-' box='Industry';
RUN;
